/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.validation;

import com.thaiopensource.relaxng.impl.CombineValidator;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import nu.validator.checker.ConformingButObsoleteWarner;
import nu.validator.checker.MicrodataChecker;
import nu.validator.checker.NormalizationChecker;
import nu.validator.checker.TextContentChecker;
import nu.validator.checker.UncheckedSubtreeWarner;
import nu.validator.checker.UnsupportedFeatureChecker;
import nu.validator.checker.UsemapChecker;
import nu.validator.checker.XmlPiChecker;
import nu.validator.checker.jing.CheckerSchema;
import nu.validator.checker.jing.CheckerValidator;
import nu.validator.checker.table.TableChecker;
import nu.validator.gnu.xml.aelfred2.SAXDriver;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.localentities.LocalCacheEntityResolver;
import nu.validator.source.SourceCode;
import nu.validator.xml.IdFilter;
import nu.validator.xml.NullEntityResolver;
import nu.validator.xml.TypedInputSource;
import nu.validator.xml.WiretapXMLReaderWrapper;
import nu.validator.xml.dataattributes.DataAttributeDroppingSchemaWrapper;
import nu.validator.xml.langattributes.XmlLangAttributeDroppingSchemaWrapper;
import nu.validator.xml.roleattributes.RoleAttributeFilteringSchemaWrapper;
import org.apache.log4j.PropertyConfigurator;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class SimpleDocumentValidator {
    private LocalCacheEntityResolver entityResolver;
    private Schema mainSchema;
    private boolean hasHtml5Schema;
    private Schema assertionSchema;
    private Validator validator;
    private SourceCode sourceCode = new SourceCode();
    private HtmlParser htmlParser = null;
    private XMLReader htmlReader;
    private SAXDriver xmlParser;
    private XMLReader xmlReader;
    private LexicalHandler lexicalHandler;

    private Schema schemaByUrl(String schemaUrl, ErrorHandler errorHandler) throws Exception, SchemaReadException {
        PropertyMapBuilder pmb = new PropertyMapBuilder();
        pmb.put(ValidateProperty.ERROR_HANDLER, errorHandler);
        pmb.put(ValidateProperty.ENTITY_RESOLVER, this.entityResolver);
        pmb.put(ValidateProperty.XML_READER_CREATOR, new Jaxp11XMLReaderCreator());
        RngProperty.CHECK_ID_IDREF.add(pmb);
        PropertyMap jingPropertyMap = pmb.toPropertyMap();
        try {
            TypedInputSource schemaInput = (TypedInputSource)this.entityResolver.resolveEntity(null, schemaUrl);
            SchemaReader sr = "application/relax-ng-compact-syntax".equals(schemaInput.getType()) ? CompactSchemaReader.getInstance() : new AutoSchemaReader();
            return sr.createSchema(schemaInput, jingPropertyMap);
        }
        catch (ClassCastException e) {
            throw new SchemaReadException(String.format("Failed to resolve schema URL \"%s\".", schemaUrl));
        }
    }

    public SimpleDocumentValidator() {
        this(true);
    }

    public SimpleDocumentValidator(boolean initializeLog4j) {
        if (initializeLog4j) {
            PropertyConfigurator.configure(SimpleDocumentValidator.class.getClassLoader().getResource("nu/validator/localentities/files/log4j.properties"));
        }
        this.entityResolver = new LocalCacheEntityResolver(new NullEntityResolver());
        this.entityResolver.setAllowRnc(true);
    }

    public SourceCode getSourceCode() {
        return this.sourceCode;
    }

    public void setUpMainSchema(String schemaUrl, ErrorHandler errorHandler) throws SAXException, Exception, SchemaReadException {
        Schema schema = this.schemaByUrl(schemaUrl, errorHandler);
        if (schemaUrl.contains("html5")) {
            try {
                this.assertionSchema = CheckerSchema.ASSERTION_SCH;
            }
            catch (Exception e) {
                throw new SchemaReadException("Failed to retrieve secondary schema.");
            }
            schema = new DataAttributeDroppingSchemaWrapper(schema);
            schema = new XmlLangAttributeDroppingSchemaWrapper(schema);
            schema = new RoleAttributeFilteringSchemaWrapper(schema);
            this.hasHtml5Schema = true;
            if ("http://s.validator.nu/html5-all.rnc".equals(schemaUrl)) {
                System.setProperty("nu.validator.schema.rdfa-full", "1");
            } else {
                System.setProperty("nu.validator.schema.rdfa-full", "0");
            }
        }
        this.mainSchema = schema;
    }

    public void setUpValidatorAndParsers(ErrorHandler docValidationErrHandler, boolean noStream, boolean loadExternalEnts) throws SAXException {
        PropertyMapBuilder pmb = new PropertyMapBuilder();
        pmb.put(ValidateProperty.ERROR_HANDLER, docValidationErrHandler);
        pmb.put(ValidateProperty.XML_READER_CREATOR, new Jaxp11XMLReaderCreator());
        RngProperty.CHECK_ID_IDREF.add(pmb);
        PropertyMap jingPropertyMap = pmb.toPropertyMap();
        this.validator = this.mainSchema.createValidator(jingPropertyMap);
        if (this.hasHtml5Schema) {
            Validator assertionValidator = this.assertionSchema.createValidator(jingPropertyMap);
            this.validator = new CombineValidator(this.validator, assertionValidator);
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new TableChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new ConformingButObsoleteWarner(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new MicrodataChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new NormalizationChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new TextContentChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new UncheckedSubtreeWarner(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new UnsupportedFeatureChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new UsemapChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new XmlPiChecker(), jingPropertyMap));
        }
        this.htmlParser = new HtmlParser();
        this.htmlParser.addCharacterHandler(this.sourceCode);
        this.htmlParser.setCommentPolicy(XmlViolationPolicy.ALLOW);
        this.htmlParser.setContentNonXmlCharPolicy(XmlViolationPolicy.ALLOW);
        this.htmlParser.setContentSpacePolicy(XmlViolationPolicy.ALTER_INFOSET);
        this.htmlParser.setNamePolicy(XmlViolationPolicy.ALLOW);
        this.htmlParser.setXmlnsPolicy(XmlViolationPolicy.ALTER_INFOSET);
        this.htmlParser.setMappingLangToXmlLang(true);
        this.htmlParser.setHtml4ModeCompatibleWithXhtml1Schemata(true);
        this.htmlParser.setDoctypeExpectation(DoctypeExpectation.HTML);
        this.htmlParser.setHeuristics(Heuristics.ALL);
        this.htmlParser.setContentHandler(this.validator.getContentHandler());
        this.htmlParser.setErrorHandler(docValidationErrHandler);
        this.htmlParser.setNamePolicy(XmlViolationPolicy.ALLOW);
        this.htmlParser.setMappingLangToXmlLang(true);
        this.htmlParser.setFeature("http://xml.org/sax/features/unicode-normalization-checking", true);
        if (!noStream) {
            this.htmlParser.setStreamabilityViolationPolicy(XmlViolationPolicy.FATAL);
        }
        this.htmlReader = this.getWiretap(this.htmlParser);
        this.xmlParser = new SAXDriver();
        this.xmlParser.setContentHandler(this.validator.getContentHandler());
        if (this.lexicalHandler != null) {
            this.xmlParser.setProperty("http://xml.org/sax/properties/lexical-handler", this.lexicalHandler);
        }
        this.xmlReader = new IdFilter(this.xmlParser);
        this.xmlReader.setFeature("http://xml.org/sax/features/string-interning", true);
        this.xmlReader.setContentHandler(this.validator.getContentHandler());
        this.xmlReader.setFeature("http://xml.org/sax/features/unicode-normalization-checking", true);
        if (loadExternalEnts) {
            this.xmlReader.setEntityResolver(this.entityResolver);
        } else {
            this.xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            this.xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            this.xmlReader.setEntityResolver(new NullEntityResolver());
        }
        this.xmlReader = this.getWiretap(this.xmlParser);
        this.xmlParser.setErrorHandler(docValidationErrHandler);
        this.xmlParser.lockErrorHandler();
    }

    private WiretapXMLReaderWrapper getWiretap(XMLReader reader) {
        WiretapXMLReaderWrapper wiretap = new WiretapXMLReaderWrapper(reader);
        ContentHandler recorder = this.sourceCode.getLocationRecorder();
        wiretap.setWiretapContentHander(recorder);
        wiretap.setWiretapLexicalHandler((LexicalHandler)((Object)recorder));
        return wiretap;
    }

    public void checkHtmlInputSource(InputSource is) throws IOException, SAXException {
        this.validator.reset();
        is.setEncoding("UTF-8");
        this.checkAsHTML(is);
    }

    public void checkXmlInputSource(InputSource is) throws IOException, SAXException {
        this.validator.reset();
        this.checkAsXML(is);
    }

    public void checkHtmlFile(File file, boolean asUTF8) throws IOException, SAXException {
        this.validator.reset();
        InputSource is = new InputSource(new FileInputStream(file));
        is.setSystemId(file.toURI().toURL().toString());
        if (asUTF8) {
            is.setEncoding("UTF-8");
        }
        this.checkAsHTML(is);
    }

    public void checkXmlFile(File file) throws IOException, SAXException {
        this.validator.reset();
        InputSource is = new InputSource(new FileInputStream(file));
        is.setSystemId(file.toURI().toURL().toString());
        this.checkAsXML(is);
    }

    public void checkHttpURL(URL url) throws IOException, SAXException {
        String address = url.toString();
        this.validator.reset();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        String contentType = connection.getContentType();
        InputSource is = new InputSource(url.openStream());
        is.setSystemId(address);
        for (String param : contentType.replace(" ", "").split(";")) {
            if (!param.startsWith("charset=")) continue;
            is.setEncoding(param.split("=", 2)[1]);
            break;
        }
        if (connection.getContentType().startsWith("text/html")) {
            this.checkAsHTML(is);
        } else {
            this.checkAsXML(is);
        }
    }

    private void checkAsHTML(InputSource is) throws IOException, SAXException {
        this.sourceCode.initialize(is);
        try {
            this.htmlReader.parse(is);
        }
        catch (SAXParseException sAXParseException) {
            // empty catch block
        }
    }

    private void checkAsXML(InputSource is) throws IOException, SAXException {
        this.xmlParser.setCharacterHandler(this.sourceCode);
        this.sourceCode.initialize(is);
        try {
            this.xmlReader.parse(is);
        }
        catch (SAXParseException sAXParseException) {
            // empty catch block
        }
    }

    public class SchemaReadException
    extends Exception {
        public SchemaReadException() {
        }

        public SchemaReadException(String message) {
            super(message);
        }
    }
}

