/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yuitest.coverage;

import com.yahoo.platform.yuitest.coverage.FileInstrumenter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.RecognitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryInstrumenter {
    private static boolean verbose = false;

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean verbose) {
        DirectoryInstrumenter.verbose = verbose;
    }

    public static void instrument(String inputDir, String outputDir) throws FileNotFoundException, UnsupportedEncodingException, IOException, RecognitionException {
        if (!inputDir.endsWith(File.separator)) {
            inputDir = inputDir + File.separator;
        }
        if (!outputDir.endsWith(File.separator)) {
            outputDir = outputDir + File.separator;
        }
        List<String> filenames = DirectoryInstrumenter.getFilenames(inputDir);
        for (int i = 0; i < filenames.size(); ++i) {
            String inputFilename = filenames.get(i);
            String outputFilename = outputDir + inputFilename.substring(inputFilename.indexOf(inputDir) + inputDir.length());
            File dir = new File(outputFilename.substring(0, outputFilename.lastIndexOf(File.separator)));
            if (!dir.exists()) {
                if (verbose) {
                    System.err.println("[INFO] Creating directory " + dir.getPath());
                }
                dir.mkdirs();
            }
            FileInstrumenter.setVerbose(verbose);
            FileInstrumenter.instrument(inputFilename, outputFilename);
        }
    }

    private static List<String> getFilenames(String directory) throws IllegalArgumentException, FileNotFoundException {
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("'" + directory + "' is not a valid directory.");
        }
        if (!dir.canRead()) {
            throw new IllegalArgumentException("'" + directory + "' cannot be read.");
        }
        LinkedList<String> filenames = new LinkedList<String>();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile() && files[i].getName().endsWith(".js")) {
                filenames.add(files[i].getPath());
                continue;
            }
            if (!files[i].isDirectory()) continue;
            filenames.addAll(DirectoryInstrumenter.getFilenames(files[i].getPath()));
        }
        return filenames;
    }
}

