/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yuitest.coverage;

import com.yahoo.platform.yuitest.coverage.ES3YUITestLexer;
import com.yahoo.platform.yuitest.coverage.ES3YUITestParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public class JavaScriptInstrumenter {
    private Reader in;
    private String name;
    private String path;

    public JavaScriptInstrumenter(Reader in, String name) {
        this(in, name, name);
    }

    public JavaScriptInstrumenter(Reader in, String name, String path) {
        this.in = in;
        this.name = name;
        this.path = path;
    }

    public void instrument(Writer out, boolean verbose) throws IOException, RecognitionException {
        InputStream stgstream = JavaScriptInstrumenter.class.getResourceAsStream("ES3YUITestTemplates.stg");
        InputStreamReader reader = new InputStreamReader(stgstream);
        StringTemplateGroup group = new StringTemplateGroup(reader);
        reader.close();
        StringTemplate headerTemplate = group.getInstanceOf("file_header");
        headerTemplate.setAttribute("src", this.name);
        headerTemplate.setAttribute("path", this.path.replace("\\", "\\\\"));
        BufferedReader lineReader = new BufferedReader(this.in);
        StringBuilder codeLines = new StringBuilder();
        StringBuilder code = new StringBuilder();
        String line = null;
        codeLines.append("_yuitest_coverage[\"");
        codeLines.append(this.name);
        codeLines.append("\"].code=[");
        while ((line = lineReader.readLine()) != null) {
            codeLines.append("\"");
            codeLines.append(line.replace("\\", "\\\\").replace("\"", "\\\""));
            codeLines.append("\",");
            code.append(line);
            code.append("\n");
        }
        switch (codeLines.charAt(codeLines.length() - 1)) {
            case ',': {
                codeLines.setCharAt(codeLines.length() - 1, ']');
                break;
            }
            case '[': {
                codeLines.append("]");
            }
        }
        codeLines.append(";");
        ANTLRReaderStream stream = new ANTLRReaderStream(new StringReader(code.toString()));
        stream.name = this.name;
        ES3YUITestLexer lexer = new ES3YUITestLexer(stream);
        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
        ES3YUITestParser parser = new ES3YUITestParser(tokens);
        parser.setTemplateLib(group);
        String result = "";
        if (code.toString().trim().length() > 0) {
            parser.program();
            result = tokens.toString();
        }
        this.in.close();
        this.in = null;
        out.write(headerTemplate.toString());
        out.write("\n");
        out.write(codeLines.toString());
        out.write("\n");
        out.flush();
        out.write(result);
        out.flush();
    }
}

