/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yuitest.coverage;

import com.yahoo.platform.yuitest.coverage.FileDirFilter;
import com.yahoo.platform.yuitest.coverage.FileInstrumenter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.RecognitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryInstrumenter {
    private static boolean verbose = false;

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean verbose) {
        DirectoryInstrumenter.verbose = verbose;
    }

    public static void instrument(String inputDir, String outputDir, HashSet<String> excludes) throws FileNotFoundException, UnsupportedEncodingException, IOException, RecognitionException {
        if (!inputDir.endsWith(File.separator)) {
            inputDir = inputDir + File.separator;
        }
        if (!outputDir.endsWith(File.separator)) {
            outputDir = outputDir + File.separator;
        }
        List<String> filenames = DirectoryInstrumenter.getFilenames(inputDir, excludes);
        for (int i = 0; i < filenames.size(); ++i) {
            String inputFilename = filenames.get(i);
            String outputFilename = outputDir + inputFilename.substring(inputFilename.indexOf(inputDir) + inputDir.length());
            File dir = new File(outputFilename.substring(0, outputFilename.lastIndexOf(File.separator)));
            if (!dir.exists()) {
                if (verbose) {
                    System.err.println("[INFO] Creating directory " + dir.getPath());
                }
                dir.mkdirs();
            }
            FileInstrumenter.setVerbose(verbose);
            FileInstrumenter.instrument(inputFilename, outputFilename);
        }
        DirectoryInstrumenter.copyExcludes(inputDir, outputDir, excludes);
    }

    private static void copyExcludes(String inputDir, String outputDir, HashSet<String> excludes) throws IOException {
        String name2 = null;
        String destName = null;
        File f = null;
        System.out.println("intput dir=" + inputDir);
        for (String name2 : excludes) {
            destName = outputDir + name2.substring(inputDir.length());
            f = new File(name2);
            if (f.isFile()) {
                System.out.println("copying skipped file " + name2 + " to " + destName);
                DirectoryInstrumenter.copyFile(f, new File(destName));
                continue;
            }
            if (!f.isDirectory()) continue;
            System.out.println("copying skipped directory " + name2 + " to " + destName);
            DirectoryInstrumenter.copyDirectory(f, new File(destName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File srcFile, File destFile) throws IOException {
        if (!srcFile.exists() || !srcFile.isFile()) {
            throw new IOException("src file does not exist or is not a file");
        }
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel src = null;
        AbstractInterruptibleChannel dest = null;
        try {
            src = new FileInputStream(srcFile).getChannel();
            dest = new FileOutputStream(destFile).getChannel();
            ((FileChannel)dest).transferFrom(src, 0L, src.size());
        }
        finally {
            if (src != null) {
                src.close();
            }
            if (dest != null) {
                dest.close();
            }
        }
    }

    private static void copyDirectory(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new IOException("src file or directory does not exist");
        }
        if (src.isFile()) {
            DirectoryInstrumenter.copyFile(src, dest);
        } else {
            if (!dest.exists()) {
                dest.mkdir();
            }
            String[] children = src.list();
            for (int i = 0; i < children.length; ++i) {
                DirectoryInstrumenter.copyDirectory(new File(src, children[i]), new File(dest, children[i]));
            }
        }
    }

    private static List<String> getFilenames(String directory, HashSet<String> excludes) throws IllegalArgumentException, FileNotFoundException {
        File dir = new File(directory);
        if (!dir.exists()) {
            throw new FileNotFoundException("'" + directory + "' does not exist.");
        }
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("'" + directory + "' is not a valid directory.");
        }
        if (!dir.canRead()) {
            throw new IllegalArgumentException("'" + directory + "' cannot be read.");
        }
        LinkedList<String> filenames = new LinkedList<String>();
        File[] files = dir.listFiles(new FileDirFilter(excludes));
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile() && files[i].getName().endsWith(".js")) {
                filenames.add(files[i].getPath());
                continue;
            }
            if (!files[i].isDirectory()) continue;
            filenames.addAll(DirectoryInstrumenter.getFilenames(files[i].getPath(), excludes));
        }
        return filenames;
    }
}

