/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yuitest.coverage;

import com.yahoo.platform.yuitest.coverage.JavaScriptInstrumenter;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.antlr.runtime.RecognitionException;

public class FileInstrumenter {
    private static boolean verbose = false;

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean verbose) {
        FileInstrumenter.verbose = verbose;
    }

    public static void instrument(String inputFilename, String outputFilename) throws FileNotFoundException, UnsupportedEncodingException, IOException, RecognitionException {
        FileInstrumenter.instrument(inputFilename, outputFilename, "UTF-8");
    }

    public static void instrument(String inputFilename, String outputFilename, String charset) throws FileNotFoundException, UnsupportedEncodingException, IOException, RecognitionException {
        block8: {
            if (verbose) {
                System.err.println("\n[INFO] Preparing to instrument JavaScript file " + inputFilename + ".");
                System.err.println("\n[INFO] Output file will be " + outputFilename + ".");
            }
            Reader in = null;
            Writer out = null;
            ByteArrayOutputStream bytes = null;
            try {
                File inputFile = new File(inputFilename);
                bytes = new ByteArrayOutputStream();
                in = new InputStreamReader((InputStream)new FileInputStream(inputFilename), charset);
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)bytes, charset));
                JavaScriptInstrumenter instrumenter = new JavaScriptInstrumenter(in, inputFilename.replaceAll("\\.\\./", ""), new File(inputFilename).getCanonicalPath());
                instrumenter.instrument(out, verbose);
            }
            catch (IOException ex) {
                in.close();
                if (out != null) {
                    out.close();
                }
                throw ex;
            }
            try {
                out.close();
                out = null;
                if (bytes.size() > 0) {
                    bytes.writeTo(new FileOutputStream(outputFilename));
                }
            }
            catch (IOException e) {
                System.err.println("[ERROR] " + e.getMessage());
                if (!verbose) break block8;
                e.printStackTrace();
            }
        }
        if (verbose) {
            System.err.println("\n[INFO] Created file " + outputFilename + ".");
        }
    }
}

