/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yuitest.coverage;

import com.yahoo.platform.yuitest.coverage.DirectoryInstrumenter;
import com.yahoo.platform.yuitest.coverage.FileInstrumenter;
import com.yahoo.platform.yuitest.coverage.JavaScriptInstrumenter;
import jargs.gnu.CmdLineParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

public class YUITestCoverage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option verboseOpt = parser.addBooleanOption('v', "verbose");
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option charsetOpt = parser.addStringOption("charset");
        CmdLineParser.Option outputLocationOpt = parser.addStringOption('o', "output");
        CmdLineParser.Option directoryOpt = parser.addBooleanOption('d', "dir");
        CmdLineParser.Option excludeOpt = parser.addStringOption('x', "exclude");
        CmdLineParser.Option stdinOpt = parser.addBooleanOption("stdin");
        CmdLineParser.Option coverFileNameOpt = parser.addStringOption("cover-name");
        Reader in = null;
        Writer out = null;
        try {
            String[] fileArgs;
            parser.parse(args);
            Boolean help = (Boolean)parser.getOptionValue(helpOpt);
            if (help != null && help.booleanValue()) {
                YUITestCoverage.usage();
                System.exit(0);
            }
            boolean verbose = parser.getOptionValue(verboseOpt) != null;
            boolean useStdin = parser.getOptionValue(stdinOpt) != null;
            String coverFileName = (String)parser.getOptionValue(coverFileNameOpt);
            String charset = (String)parser.getOptionValue(charsetOpt);
            if (charset == null || !Charset.isSupported(charset)) {
                charset = System.getProperty("file.encoding");
                if (charset == null) {
                    charset = "UTF-8";
                }
                if (verbose) {
                    System.err.println("\n[INFO] Using charset " + charset);
                }
            }
            if ((fileArgs = parser.getRemainingArgs()).length == 0 && !useStdin) {
                YUITestCoverage.usage();
                System.exit(1);
            }
            String outputLocation = (String)parser.getOptionValue(outputLocationOpt);
            Boolean directories = parser.getOptionValue(directoryOpt) != null;
            if (outputLocation == null) {
                if (directories.booleanValue()) {
                    throw new Exception("-o option is required with -d option.");
                }
                if (verbose) {
                    System.err.println("\n[INFO] Preparing to instrument JavaScript file " + fileArgs[0] + ".");
                }
                in = useStdin ? new InputStreamReader(System.in, charset) : new InputStreamReader((InputStream)new FileInputStream(fileArgs[0]), charset);
                String fileName = coverFileName != null ? coverFileName : (fileArgs.length > 0 ? fileArgs[0] : "<stdin>");
                JavaScriptInstrumenter instrumenter = new JavaScriptInstrumenter(in, fileName, fileName);
                out = new OutputStreamWriter((OutputStream)System.out, charset);
                instrumenter.instrument(out, verbose);
            } else if (directories.booleanValue()) {
                Vector excludeValues = parser.getOptionValues(excludeOpt);
                HashSet<String> excludes = new HashSet<String>();
                String parentPath = fileArgs[0].endsWith("/") ? fileArgs[0] : fileArgs[0] + '/';
                String skip = "";
                Enumeration elems = excludeValues.elements();
                while (elems.hasMoreElements()) {
                    skip = parentPath + (String)elems.nextElement();
                    if (verbose) {
                        System.out.println("\n[INFO] Skipping instrumentation for " + skip);
                    }
                    excludes.add(skip);
                }
                DirectoryInstrumenter.setVerbose(verbose);
                DirectoryInstrumenter.instrument(fileArgs[0], outputLocation, excludes);
            } else {
                FileInstrumenter.setVerbose(verbose);
                FileInstrumenter.instrument(fileArgs[0], outputLocation);
            }
        }
        catch (CmdLineParser.OptionException e) {
            YUITestCoverage.usage();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void usage() {
        System.out.println("\nUsage: java -jar yuitest-coverage-x.y.z.jar [options] [file|dir]\n\nGlobal Options\n  -h, --help              Displays this information.\n  --charset <charset>     Read the input file using <charset>.\n  --stdin                 Read input from stdin  --cover-name            When intrumenting, use this name instead of the filename (mainly for stdin)  -d, --dir               Input and output (-o) are both directories.\n  -v, --verbose           Display informational messages and warnings.\n  -o <file|dir>           Place the output into <file|dir>. Defaults to stdout.\n\n");
    }
}

