/*
 * Decompiled with CFR 0.152.
 */
package com.bolan9999;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.DecelerateInterpolator;

abstract class DecelerateAnimation {
    protected ValueAnimator animator;
    public boolean animating;

    public DecelerateAnimation(float base, float v, float dampingCoefficient) {
        int duration = 0;
        float displacement = 0.0f;
        while (Math.abs(v) > 0.1f) {
            displacement += v;
            v *= dampingCoefficient;
            ++duration;
        }
        this.animator = ValueAnimator.ofFloat((float[])new float[]{base, base - displacement});
        this.animator.setDuration((long)duration);
    }

    public DecelerateAnimation(float from, float to, long duration) {
        this.animator = ValueAnimator.ofFloat((float[])new float[]{from, to});
        this.animator.setDuration(duration);
    }

    public void start() {
        this.animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.5f));
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                DecelerateAnimation.this.onUpdate(((Float)animator.getAnimatedValue()).floatValue());
            }
        });
        this.animating = true;
        this.animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                DecelerateAnimation.this.animating = false;
                DecelerateAnimation.this.onEnd();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.animator.start();
    }

    public boolean cancel() {
        boolean cancel = this.animating;
        this.animator.cancel();
        return cancel;
    }

    protected void onEnd() {
    }

    protected abstract void onUpdate(float var1);
}

