/*
 * Decompiled with CFR 0.152.
 */
package com.bolan9999;

import android.content.Context;
import android.os.Build;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.bolan9999.DecelerateAnimation;
import com.bolan9999.EdgeInsets;
import com.bolan9999.Offset;
import com.bolan9999.Point;
import com.bolan9999.ScrollEvent;
import com.bolan9999.Size;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.views.scroll.ReactScrollViewHelper;
import com.facebook.react.views.view.ReactViewGroup;

public class SpringScrollView
extends ReactViewGroup
implements View.OnTouchListener,
View.OnLayoutChangeListener {
    private float refreshHeaderHeight;
    private float loadingFooterHeight;
    private boolean momentumScrolling;
    private boolean bounces;
    private boolean scrollEnabled;
    private boolean dragging;
    private boolean inverted;
    private boolean directionalLockEnabled;
    private VelocityTracker tracker;
    private DecelerateAnimation verticalAnimation;
    private DecelerateAnimation horizontalAnimation;
    private String refreshStatus = "waiting";
    private String loadingStatus = "waiting";
    private String draggingDirection;
    private Offset contentOffset;
    private Offset initContentOffset = new Offset();
    private Size size;
    private Size contentSize;
    private Point lastPoint;
    private Point beginPoint;
    private EdgeInsets contentInsets;

    public SpringScrollView(@NonNull Context context) {
        super(context);
        this.contentOffset = new Offset();
        this.contentInsets = new EdgeInsets();
        this.size = new Size();
        this.contentSize = new Size();
        this.lastPoint = new Point();
        this.beginPoint = new Point();
        this.setClipChildren(false);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(true);
        }
    }

    protected void onAttachedToWindow() {
        this.setOnTouchListener(this);
        this.addOnLayoutChangeListener(this);
        ViewGroup child = (ViewGroup)this.getChildAt(0);
        if (child != null) {
            if (this.initContentOffset.y != 0.0f) {
                this.setContentOffset(this.initContentOffset.x, this.initContentOffset.y);
            }
            child.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
            child.setClipChildren(false);
        }
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        this.setOnTouchListener(null);
        this.removeOnLayoutChangeListener(this);
        View child = this.getChildAt(0);
        if (child != null) {
            child.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        }
        super.onDetachedFromWindow();
    }

    public void onLayoutChange(View view, int i, int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
        if (this == view) {
            this.size.width = i2 - i;
            this.size.height = i3 - i1;
        } else {
            this.setContentSize(i2 - i, i3 - i1);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        switch (action) {
            case 0: {
                this.onDown(ev);
                return false;
            }
            case 2: {
                if (!this.shouldDrag(ev)) break;
                this.dragging = true;
                this.requestDisallowInterceptTouchEvent(true);
                NativeGestureUtil.notifyNativeGestureStarted((View)this, (MotionEvent)ev);
                ReactScrollViewHelper.emitScrollBeginDragEvent((ViewGroup)this);
                return true;
            }
        }
        return this.dragging;
    }

    private boolean shouldDrag(MotionEvent ev) {
        return this.dragging || this.canHorizontalScroll() && Math.abs(ev.getX() - this.beginPoint.x) > PixelUtil.toPixelFromDIP((float)10.0f) || this.scrollEnabled && Math.abs(ev.getY() - this.beginPoint.y) > PixelUtil.toPixelFromDIP((float)5.0f);
    }

    public boolean onTouch(View view, MotionEvent evt) {
        switch (evt.getAction() & 0xFF) {
            case 2: {
                this.onMove(evt);
                break;
            }
            case 1: 
            case 3: {
                this.onUp(evt);
            }
        }
        return true;
    }

    private void onDown(MotionEvent evt) {
        this.beginPoint.x = this.lastPoint.x = evt.getX();
        this.beginPoint.y = this.lastPoint.y = evt.getY();
        if (this.cancelAllAnimations()) {
            this.dragging = true;
        }
        if (this.momentumScrolling) {
            this.momentumScrolling = false;
            this.sendEvent("onMomentumScrollEnd", null);
        }
        this.sendEvent("onTouchBegin", null);
        this.tracker = VelocityTracker.obtain();
    }

    private void onMove(MotionEvent evt) {
        if (!this.scrollEnabled) {
            return;
        }
        this.drag(this.lastPoint.x - evt.getX(), this.lastPoint.y - evt.getY());
        this.lastPoint.x = evt.getX();
        this.lastPoint.y = evt.getY();
        this.tracker.addMovement(evt);
    }

    private void onUp(MotionEvent evt) {
        this.onMove(evt);
        this.dragging = false;
        this.tracker.computeCurrentVelocity(1);
        float vy = this.tracker.getYVelocity();
        float vx = this.tracker.getXVelocity();
        if (this.inverted && Build.VERSION.SDK_INT >= 28) {
            vx = -vx;
            vy = -vy;
        }
        if (this.draggingDirection != null && this.draggingDirection.equals("h")) {
            vy = 0.0f;
        } else if (this.draggingDirection != null && this.draggingDirection.equals("v")) {
            vx = 0.0f;
        }
        this.draggingDirection = null;
        this.tracker.clear();
        WritableMap param = Arguments.createMap();
        param.putArray("touches", (ReadableArray)Arguments.createArray());
        this.sendEvent("onTouchEnd", param);
        if (!this.momentumScrolling) {
            this.momentumScrolling = true;
            this.sendEvent("onMomentumScrollBegin", null);
        }
        if (this.shouldRefresh()) {
            this.refreshStatus = "refreshing";
            this.contentInsets.top = this.refreshHeaderHeight;
        }
        if (this.shouldLoad()) {
            this.loadingStatus = "loading";
            this.contentInsets.bottom = this.loadingFooterHeight;
        }
        this.requestDisallowInterceptTouchEvent(false);
        if (!this.scrollEnabled) {
            return;
        }
        if (this.overshootVertical()) {
            this.beginOuterAnimation(vy);
        } else {
            this.beginInnerAnimation(vy);
        }
        if (this.contentSize.width <= this.size.width) {
            return;
        }
        if (this.overshootHorizontal()) {
            this.beginOuterHorizontalAnimation(vx);
        } else {
            this.beginInnerHorizontalAnimation(vx);
        }
    }

    private void beginInnerHorizontalAnimation(final float initialVelocity) {
        if (Math.abs(initialVelocity) < 0.1f) {
            return;
        }
        final long beginTimeInterval = System.currentTimeMillis();
        this.horizontalAnimation = new DecelerateAnimation(this.contentOffset.x, initialVelocity, 0.997f){

            @Override
            protected void onEnd() {
                if (SpringScrollView.this.momentumScrolling) {
                    SpringScrollView.this.momentumScrolling = false;
                    SpringScrollView.this.sendEvent("onMomentumScrollEnd", null);
                }
            }

            @Override
            protected void onUpdate(float value) {
                SpringScrollView.this.setContentOffset(value, ((SpringScrollView)SpringScrollView.this).contentOffset.y);
                if (SpringScrollView.this.overshootHorizontal()) {
                    long interval = System.currentTimeMillis() - beginTimeInterval;
                    float v = initialVelocity;
                    while (interval-- > 0L) {
                        v *= 0.997f;
                    }
                    this.animator.cancel();
                    SpringScrollView.this.horizontalAnimation = null;
                    SpringScrollView.this.beginOuterHorizontalAnimation(v);
                }
            }
        };
        this.horizontalAnimation.start();
    }

    private void beginOuterHorizontalAnimation(float initialVelocity) {
        if (Math.abs(initialVelocity) < 0.1f) {
            this.beginHorizontalReboundAnimation();
            return;
        }
        if (initialVelocity > 15.0f) {
            initialVelocity = 15.0f;
        }
        if (initialVelocity < -15.0f) {
            initialVelocity = -15.0f;
        }
        this.horizontalAnimation = new DecelerateAnimation(this.contentOffset.x, initialVelocity, 0.9f){

            @Override
            protected void onEnd() {
                SpringScrollView.this.beginHorizontalReboundAnimation();
            }

            @Override
            protected void onUpdate(float value) {
                if (!SpringScrollView.this.bounces) {
                    ((SpringScrollView)SpringScrollView.this).contentOffset.x = value;
                    if (SpringScrollView.this.overshootLeft()) {
                        value = -((SpringScrollView)SpringScrollView.this).contentInsets.left;
                        SpringScrollView.this.horizontalAnimation.cancel();
                    } else if (SpringScrollView.this.overshootRight()) {
                        value = ((SpringScrollView)SpringScrollView.this).contentSize.width - ((SpringScrollView)SpringScrollView.this).size.width + ((SpringScrollView)SpringScrollView.this).contentInsets.right;
                        SpringScrollView.this.horizontalAnimation.cancel();
                    }
                }
                SpringScrollView.this.setContentOffset(value, ((SpringScrollView)SpringScrollView.this).contentOffset.y);
            }
        };
        this.horizontalAnimation.start();
    }

    private void beginHorizontalReboundAnimation() {
        if (!this.overshootHorizontal() || !this.bounces) {
            return;
        }
        float endValue = this.overshootLeft() ? -this.contentInsets.left : this.contentSize.width - this.size.width + this.contentInsets.right;
        this.horizontalAnimation = new DecelerateAnimation(this.contentOffset.x, endValue, 500L){

            @Override
            protected void onEnd() {
                if (SpringScrollView.this.momentumScrolling) {
                    SpringScrollView.this.momentumScrolling = false;
                    SpringScrollView.this.sendEvent("onMomentumScrollEnd", null);
                }
            }

            @Override
            protected void onUpdate(float value) {
                SpringScrollView.this.setContentOffset(value, ((SpringScrollView)SpringScrollView.this).contentOffset.y);
            }
        };
        this.horizontalAnimation.start();
    }

    private void beginInnerAnimation(final float initialVelocity) {
        if (Math.abs(initialVelocity) < 0.1f) {
            if (this.momentumScrolling) {
                this.momentumScrolling = false;
                this.sendEvent("onMomentumScrollEnd", null);
            }
            return;
        }
        final long beginTimeInterval = System.currentTimeMillis();
        this.verticalAnimation = new DecelerateAnimation(this.contentOffset.y, initialVelocity, 0.997f){

            @Override
            protected void onEnd() {
                if (SpringScrollView.this.momentumScrolling) {
                    SpringScrollView.this.momentumScrolling = false;
                    SpringScrollView.this.sendEvent("onMomentumScrollEnd", null);
                }
            }

            @Override
            protected void onUpdate(float value) {
                SpringScrollView.this.setContentOffset(((SpringScrollView)SpringScrollView.this).contentOffset.x, value);
                if (SpringScrollView.this.overshootHead() || SpringScrollView.this.overshootFooter()) {
                    long interval = System.currentTimeMillis() - beginTimeInterval;
                    float v = initialVelocity;
                    while (interval-- > 0L) {
                        v *= 0.997f;
                    }
                    this.animator.cancel();
                    SpringScrollView.this.beginOuterAnimation(v);
                }
            }
        };
        this.verticalAnimation.start();
    }

    private void beginOuterAnimation(float initialVelocity) {
        if (Math.abs(initialVelocity) < 0.1f) {
            this.beginReboundAnimation();
            return;
        }
        if (initialVelocity > 15.0f) {
            initialVelocity = 15.0f;
        }
        if (initialVelocity < -15.0f) {
            initialVelocity = -15.0f;
        }
        this.verticalAnimation = new DecelerateAnimation(this.contentOffset.y, initialVelocity, 0.9f){

            @Override
            protected void onEnd() {
                SpringScrollView.this.beginReboundAnimation();
            }

            @Override
            protected void onUpdate(float value) {
                if (!SpringScrollView.this.bounces) {
                    ((SpringScrollView)SpringScrollView.this).contentOffset.y = value;
                    if (SpringScrollView.this.overshootHead()) {
                        value = -((SpringScrollView)SpringScrollView.this).contentInsets.top;
                        SpringScrollView.this.verticalAnimation.cancel();
                    } else if (SpringScrollView.this.overshootFooter()) {
                        value = ((SpringScrollView)SpringScrollView.this).contentSize.height - ((SpringScrollView)SpringScrollView.this).size.height + ((SpringScrollView)SpringScrollView.this).contentInsets.bottom;
                        SpringScrollView.this.verticalAnimation.cancel();
                    }
                }
                SpringScrollView.this.setContentOffset(((SpringScrollView)SpringScrollView.this).contentOffset.x, value);
            }
        };
        this.verticalAnimation.start();
    }

    private void beginReboundAnimation() {
        if (!this.overshootVertical() || !this.bounces) {
            return;
        }
        float endValue = this.overshootHead() ? -this.contentInsets.top : this.contentSize.height - this.size.height + this.contentInsets.bottom;
        this.verticalAnimation = new DecelerateAnimation(this.contentOffset.y, endValue, 500L){

            @Override
            protected void onEnd() {
                if (SpringScrollView.this.momentumScrolling) {
                    SpringScrollView.this.momentumScrolling = false;
                    SpringScrollView.this.sendEvent("onMomentumScrollEnd", null);
                }
            }

            @Override
            protected void onUpdate(float value) {
                SpringScrollView.this.setContentOffset(((SpringScrollView)SpringScrollView.this).contentOffset.x, value);
            }
        };
        this.verticalAnimation.start();
    }

    private boolean cancelAllAnimations() {
        boolean cancel = false;
        if (this.verticalAnimation != null) {
            cancel = this.verticalAnimation.cancel();
            this.verticalAnimation = null;
        }
        if (this.horizontalAnimation != null) {
            cancel = this.horizontalAnimation.cancel();
            this.horizontalAnimation = null;
        }
        return cancel;
    }

    private void drag(float x, float y) {
        y *= this.getYDampingCoefficient();
        x *= this.getXDampingCoefficient();
        if (this.directionalLockEnabled) {
            if (this.draggingDirection == null) {
                this.draggingDirection = Math.abs(x) > Math.abs(y) ? "h" : "v";
            }
            if (this.draggingDirection.equals("h")) {
                y = 0.0f;
            }
            if (this.draggingDirection.equals("v")) {
                x = 0.0f;
            }
        }
        this.moveToOffset(this.contentOffset.x + x, this.contentOffset.y + y);
    }

    private float getYDampingCoefficient() {
        if (!this.overshootVertical()) {
            return 1.0f;
        }
        float overshoot = this.overshootHead() ? -this.contentOffset.y : this.contentOffset.y - this.contentSize.height + this.size.height;
        float c = 0.8f;
        return c / (this.size.height * this.size.height) * (overshoot * overshoot) - 2.0f * c / this.size.height * overshoot + c;
    }

    private float getXDampingCoefficient() {
        float overshoot;
        if (this.overshootLeft()) {
            overshoot = -this.contentOffset.x;
        } else if (this.overshootRight()) {
            overshoot = this.contentOffset.x - this.contentSize.width + this.size.width;
        } else {
            return 1.0f;
        }
        float c = 0.8f;
        return c / (this.size.width * this.size.width) * (overshoot * overshoot) - 2.0f * c / this.size.width * overshoot + c;
    }

    private void moveToOffset(float x, float y) {
        if (!this.scrollEnabled) {
            return;
        }
        if (!this.bounces) {
            if (y < -this.contentInsets.top) {
                y = -this.contentInsets.top;
            }
            if (y > this.contentSize.height - this.size.height + this.contentInsets.bottom) {
                y = this.contentSize.height - this.size.height + this.contentInsets.bottom;
            }
        }
        if (this.contentSize.width <= this.size.width || !this.bounces) {
            if (x < -this.contentInsets.left) {
                x = -this.contentInsets.left;
            }
            if (x > this.contentSize.width - this.size.width + this.contentInsets.right) {
                x = this.contentSize.width - this.size.width + this.contentInsets.right;
            }
        }
        if (this.contentOffset.y == y && this.contentOffset.x == x) {
            return;
        }
        if (this.shouldPulling()) {
            this.refreshStatus = "pulling";
        } else if (this.shouldPullingEnough()) {
            this.refreshStatus = "pullingEnough";
        } else if (this.shouldPullingCancel()) {
            this.refreshStatus = "pullingCancel";
        } else if (this.shouldWaiting()) {
            this.refreshStatus = "waiting";
        }
        if (this.shouldDragging()) {
            this.loadingStatus = "dragging";
        } else if (this.shouldDraggingEnough()) {
            this.loadingStatus = "draggingEnough";
        } else if (this.shouldDraggingCancel()) {
            this.loadingStatus = "draggingCancel";
        } else if (this.shouldFooterWaiting()) {
            this.loadingStatus = "waiting";
        }
        this.setContentOffset(x, y);
    }

    public void setContentOffset(float x, float y) {
        this.contentOffset.x = x;
        this.contentOffset.y = y;
        View child = this.getChildAt(0);
        if (child != null) {
            child.setTranslationX(-this.contentOffset.x);
            child.setTranslationY(-this.contentOffset.y);
        }
        WritableMap event = Arguments.createMap();
        WritableMap contentOffsetMap = Arguments.createMap();
        contentOffsetMap.putDouble("x", (double)PixelUtil.toDIPFromPixel((float)this.contentOffset.x));
        contentOffsetMap.putDouble("y", (double)PixelUtil.toDIPFromPixel((float)this.contentOffset.y));
        event.putMap("contentOffset", (ReadableMap)contentOffsetMap);
        event.putString("refreshStatus", this.refreshStatus);
        event.putString("loadingStatus", this.loadingStatus);
        this.sendOnScrollEvent(event);
    }

    private boolean overshootVertical() {
        return this.overshootHead() || this.overshootFooter();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        View child = this.getChildAt(0);
        assert (child != null);
        this.size.width = this.getWidth();
        this.size.height = this.getHeight();
        this.setContentSize(child.getMeasuredWidth(), child.getMeasuredHeight());
    }

    private void setContentSize(float width, float height) {
        if (height < this.size.height) {
            height = this.size.height;
        }
        if (width < this.size.width) {
            width = this.size.width;
        }
        this.contentSize.width = width;
        this.contentSize.height = height;
    }

    public void setRefreshHeaderHeight(float height) {
        this.refreshHeaderHeight = height;
    }

    public void setLoadingFooterHeight(float height) {
        this.loadingFooterHeight = height;
    }

    private void sendOnScrollEvent(WritableMap event) {
        if (event == null) {
            event = Arguments.createMap();
        }
        EventDispatcher eventDispatcher = ((UIManagerModule)((ReactContext)this.getContext()).getNativeModule(UIManagerModule.class)).getEventDispatcher();
        eventDispatcher.dispatchEvent((Event)ScrollEvent.obtain(this.getId(), "onScroll", event));
    }

    private void sendEvent(String evtName, WritableMap event) {
        if (event == null) {
            event = Arguments.createMap();
        }
        ((RCTEventEmitter)((ReactContext)this.getContext()).getJSModule(RCTEventEmitter.class)).receiveEvent(this.getId(), evtName, event);
    }

    public void endRefresh() {
        if (!this.refreshStatus.equals("refreshing")) {
            return;
        }
        this.refreshStatus = "rebound";
        if (this.verticalAnimation != null) {
            this.verticalAnimation.cancel();
        }
        this.contentInsets.top = 0.0f;
        this.verticalAnimation = new DecelerateAnimation(this.contentOffset.y, 0.0f, 500L){

            @Override
            protected void onUpdate(float value) {
                SpringScrollView.this.setContentOffset(((SpringScrollView)SpringScrollView.this).contentOffset.x, value);
            }
        };
        this.verticalAnimation.start();
    }

    public void endLoading() {
        if (!this.loadingStatus.equals("loading")) {
            return;
        }
        this.loadingStatus = "rebound";
        if (this.verticalAnimation != null) {
            this.verticalAnimation.cancel();
        }
        this.contentInsets.bottom = 0.0f;
        this.verticalAnimation = new DecelerateAnimation(this.contentOffset.y, this.contentSize.height - this.size.height, 500L){

            @Override
            protected void onUpdate(float value) {
                SpringScrollView.this.setContentOffset(((SpringScrollView)SpringScrollView.this).contentOffset.x, value);
            }
        };
        this.verticalAnimation.start();
    }

    public void setAllLoaded(boolean allLoaded) {
        String string = this.loadingStatus = allLoaded ? "allLoaded" : "waiting";
        if (allLoaded) {
            this.contentInsets.bottom = 0.0f;
        }
    }

    public void scrollTo(float x, float y, boolean animated) {
        this.cancelAllAnimations();
        if (!animated) {
            this.moveToOffset(x, y);
            return;
        }
        this.verticalAnimation = new DecelerateAnimation(this.contentOffset.y, y, 500L){

            @Override
            protected void onEnd() {
            }

            @Override
            protected void onUpdate(float value) {
                SpringScrollView.this.setContentOffset(((SpringScrollView)SpringScrollView.this).contentOffset.x, value);
            }
        };
        this.verticalAnimation.start();
        if (x != this.contentOffset.x) {
            this.verticalAnimation = new DecelerateAnimation(this.contentOffset.x, x, 500L){

                @Override
                protected void onEnd() {
                }

                @Override
                protected void onUpdate(float value) {
                    SpringScrollView.this.setContentOffset(value, ((SpringScrollView)SpringScrollView.this).contentOffset.y);
                }
            };
            this.verticalAnimation.start();
        }
    }

    public void setBounces(boolean bounces) {
        this.bounces = bounces;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        this.scrollEnabled = scrollEnabled;
    }

    public void setInitContentOffset(float x, float y) {
        this.initContentOffset.x = x;
        this.initContentOffset.y = y;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public void setDirectionalLockEnabled(boolean directionalLockEnabled) {
        this.directionalLockEnabled = directionalLockEnabled;
    }

    private boolean overshootHead() {
        return this.contentOffset.y < -this.contentInsets.top;
    }

    private boolean overshootRefresh() {
        return this.contentOffset.y < -this.contentInsets.top - this.refreshHeaderHeight;
    }

    private boolean overshootFooter() {
        return this.contentOffset.y > this.contentSize.height - this.size.height;
    }

    private boolean overshootLoading() {
        return this.contentOffset.y > -this.size.height + this.contentSize.height + this.loadingFooterHeight;
    }

    private boolean overshootLeft() {
        return this.contentOffset.x < -this.contentInsets.left;
    }

    private boolean overshootRight() {
        return this.contentOffset.x > this.contentInsets.right + this.contentSize.width - this.size.width;
    }

    private boolean overshootHorizontal() {
        return this.overshootLeft() || this.overshootRight();
    }

    private boolean shouldPulling() {
        return this.refreshHeaderHeight > 0.0f && this.overshootHead() && (this.refreshStatus.equals("waiting") || this.refreshStatus.equals("pullingCancel"));
    }

    private boolean shouldPullingEnough() {
        return this.refreshHeaderHeight > 0.0f && this.overshootRefresh() && this.refreshStatus.equals("pulling");
    }

    private boolean shouldRefresh() {
        return this.refreshHeaderHeight > 0.0f && this.overshootRefresh() && this.refreshStatus.equals("pullingEnough");
    }

    private boolean shouldPullingCancel() {
        return this.refreshHeaderHeight > 0.0f && this.refreshStatus.equals("pullingEnough") && this.overshootHead() && !this.overshootRefresh();
    }

    private boolean shouldWaiting() {
        return this.refreshHeaderHeight > 0.0f && !this.overshootHead() && (this.refreshStatus.equals("rebound") || this.refreshStatus.equals("pullingCancel"));
    }

    private boolean shouldDragging() {
        return this.loadingFooterHeight > 0.0f && this.overshootFooter() && (this.loadingStatus.equals("waiting") || this.loadingStatus.equals("draggingCancel"));
    }

    private boolean shouldDraggingEnough() {
        return this.loadingFooterHeight > 0.0f && this.overshootLoading() && this.loadingStatus.equals("dragging");
    }

    private boolean shouldLoad() {
        return this.loadingFooterHeight > 0.0f && this.overshootLoading() && this.loadingStatus.equals("draggingEnough");
    }

    private boolean shouldDraggingCancel() {
        return this.loadingFooterHeight > 0.0f && this.loadingStatus.equals("draggingEnough") && this.overshootFooter() && !this.overshootLoading();
    }

    private boolean shouldFooterWaiting() {
        return this.loadingFooterHeight > 0.0f && !this.overshootFooter() && (this.loadingStatus.equals("rebound") || this.loadingStatus.equals("draggingCancel"));
    }

    private boolean canHorizontalScroll() {
        return this.scrollEnabled && this.contentSize.width > this.size.width;
    }
}

